package UI;

import Back.Node;
import Back.Tree;
import GraphicThreads.CompareThread;
import GraphicThreads.GraphicThread;
import GraphicThreads.JoinThread;
import GraphicThreads.LoadThread;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Line;

import java.io.Serializable;
import java.util.ArrayList;

public class MyPane<T extends Serializable & Comparable<T>> extends Pane {

        private Tree<T> tree1, tree2;
        private int r ;
        private GraphicThread<T> gt;
        private int width, height;
        Main main;


        /**
         konstruktor custom pane, prideli stromy
         @param _tree1 strom1
         @param _tree2 strom2
         */
        public MyPane(Tree<T> _tree1, Tree<T> _tree2, int width, int height, Main main ){

            tree1 = _tree1;
            tree2 = _tree2;
            r = 25;
            this.width = width;
            this.height = height;
            this.main = main;
        }


        /**
         * nastavi tree1
         @param tree1
         */
        public void setTree1(Tree<T> tree1) {
            this.tree1 = tree1;
        }

        /**
         * nastavi tree2
         @param tree2
         */
        public void setTree2(Tree<T> tree2) {
            this.tree2 = tree2;
        }

        /**
         @return vrati joinovaci thread
         */
        public GraphicThread getThread(){
            return gt;
        }

        /**
         * nastavi tree1, tree1
         @param t1 tree1
         @param t2 tree2
         */
        public void setTree( Tree<T> t1, Tree<T> t2){
            tree1 = t1;
            tree2 = t2;
        }

        /**
         @return vrati tree1
         */
        public Tree<T> getTree1( ){
            return tree1;
        }

        /**
         @return vrati tree2
         */
        public Tree<T> getTree2( ){
            return tree2;
        }

        /**
         * nastavi thread na parameter
         @param gt thread ktory bude nastaveny
         */
        public void setThread(GraphicThread<T> gt) {
            this.gt = gt;
        }


        /**
         * kedze thready sa nemaju ako priamo dostat k scene
         * a menit "buttons", tato metoda funguje ako taky
         * prechod
         @param message zavola metodu ok() s message
         */
        public void setOk(String message ){
            main.ok(message);
        }


        /**
         vymaze aktualne objekty v children
         zavola metodu ktora do nich prida stromy
         */
        public void update(){

            getChildren().clear();
            if (tree1 != null) {
                paint(tree1, 0, tree1.getRoot().height(), false);
            }
            if ( gt instanceof JoinThread | gt instanceof CompareThread ) {
                if ( tree2 != null ) paint(tree2, height / 2, tree2.getRoot().height(), false);
                //System.out.println("JointThread");
            }

            if ( gt instanceof LoadThread){
                if ( ((LoadThread<?>) gt).getNext_t() != null ){
                    if ( tree2 != null ) paint(tree2, height / 2, tree2.getRoot().height(), false);
                    //System.out.println("LOADTHREAD");
                }
            }


        }

        /**
         koncova metoda, vykresli sa iba tree1 bez zafarbenia
         */
        public void end(){
            getChildren().clear();
            if  (tree1 != null ) paint(tree1, 0, tree1.getRoot().height(), true );
            main.menuButtons();
        }

        /**
         * vypocita optimalne rozpolozenie grafickych Nodov,
         * vytvori ich, prida do deti, vytvori ciary k otcom
         @param end premenna ktora je true ak sa vykresluje posledny krat- strom je vacsi bez farieb
         @param h - vyska stromu
         @param tree - sam strom
         @param y_od - y suradnica odkial sa moze kreslit
         */
        public void paint( Tree tree, double y_od, int h, boolean end ){
            if ( tree == null ){
                return;
            }

            double n_y;

            if ( end |  ! ( gt instanceof JoinThread | gt instanceof CompareThread) ){
                n_y = height / ( h * 2 + 3 );
            } else {
                n_y = (height / 2) / (h * 2 + 3);
            }

            if ( gt instanceof LoadThread) { // buguje, nejak to nesedi v jednom if tak je to takto :(
                if ( ((LoadThread<?>) gt).getNext_t() != null ){
                    n_y = (height / 2) / (h * 2 + 3);
                }
            }


            int r = 50;
            int stroke_width = 5;
            int level = 0;
            double y = y_od+10;

            ArrayList<Node> list = new ArrayList<Node>(tree.getLevel(level));
            ArrayList<Node> pred = new ArrayList<Node>();

            while ( !list.isEmpty()){
                double n_x = width/(list.size()+1);
                if ( n_x < r*2 ){
                    if ( r > 10 ){
                        r-=10;
                        stroke_width-=1;
                    }
                }

                for ( int i = 0; i < list.size(); i++ ) {
                    double x = n_x*(i+1);

                    Node node = list.get(i);
                    if ( end ){

                        node.setAdd(false);
                        node.setFind(false);
                    }

                    GraphicNode gn = new GraphicNode(node, x, y, r,stroke_width);
                    getChildren().add(gn);
                    gn.paint();

                }
                int f_x =  width / (pred.size()+1);
                int pocet = 0;


                for (int i = 0; i < pred.size() ; i++){
                    Node father = pred.get(i);
                    for ( int j = 0; j < father.getSons().size(); j++) {
                        pocet++;
                        Line l = new Line(f_x *(i+1) + r/2,  y - ( 2 * n_y) + r + 3, n_x*(pocet) + r/2, y - 2  );
                        getChildren().add(l);
                    }
                }
                y += ( 2 *  n_y);
                pred.clear();
                pred.addAll(list);
                level++;
                list = new ArrayList<Node>(tree.getLevel(level));
            }
        }
}

